package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bDelegaciones;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;


import w83b.w83bBeans.W83bDelegacionesBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaDelegacionesExcelAction.
 *
 * @author jrgil
 */
public class W83bTablaDelegacionesExcelAction extends Q70ActionPasoOP{


	
	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processOP(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		W83bDelegacionesBean delegacionesBean = (W83bDelegacionesBean)contexto.get("w83bDelegacionesBean");
		contexto.set("w83bDelegacionesTempBean",delegacionesBean);
	}

	/* (non-Javadoc)
	 * @see es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP#processForward(es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE, org.apache.struts.action.ActionErrors, org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoDelegaciones.xls";
		InputStream inputStream = W83bTablaDelegacionesExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaDelegaciones = (ArrayList)contexto.get("w83bListaDelegaciones");
        W83bDelegacionesBean delegacionesBean = (W83bDelegacionesBean)contexto.get("w83bDelegacionesTempBean");    
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);    

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);    
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);    
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));    
        HashMap mapaDelegaciones=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);    
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1    
        HSSFCell cell = row.createCell((short)3);    
        row = sheet.getRow((short)4);    
        cell = row.getCell((short)4);    
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaDelegaciones.get("tituloDepEs");    
        StringBuffer tituloImagenEu =  (StringBuffer)mapaDelegaciones.get("tituloDepEu");    
        cell.setCellValue(tituloImagenEu.toString());    
        
        cell = row.getCell((short)9);    
        cell.setCellValue(tituloImagenEs.toString());    
        
        tituloImagenEs = (StringBuffer)mapaDelegaciones.get("tituloDelelegacionEs");    
        tituloImagenEu = (StringBuffer)mapaDelegaciones.get("tituloDelelegacionEu");    

        row = sheet.getRow((short)6);    
        cell = row.getCell((short)4);    
        cell.setCellValue(tituloImagenEu.toString());    
        
        cell = row.getCell((short)9);     
        cell.setCellValue(tituloImagenEs.toString());    
        
        row = sheet.getRow((short)9);     
        cell = row.getCell((short)0);    
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.listadoDelegaciones").toUpperCase());    
        
        //MAPEO FORMULARIO
      //fila 10, columna 2
        row = sheet.getRow((short)12);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.codTerritorioBusqueda"));
        cell = row.createCell((short)2);
        if(StringUtils.isNotEmpty(delegacionesBean.getDescTerritorio())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("4")));//NOPMD
        	cell.setCellValue(delegacionesBean.getDescTerritorio().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue(delegacionesBean.getCodTerritorio());
        }
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.codPostalBusqueda"));
        cell = row.createCell((short)10);
        if(!StringUtils.isEmpty(delegacionesBean.getCodPostal())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("10"),W83bClsConstantes.DOCE,Short.parseShort("11")));//NOPMD
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getCodPostal()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.numModeloBusqueda"));
        cell = row.createCell((short)16);
        if(!StringUtils.isEmpty(delegacionesBean.getNumModelo())){
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getNumModelo()));
        	cell.setCellStyle(estiloCabeceraIzquierda(12,excel));
        }else{
        	cell.setCellValue("");
        }
        
      //fila 11, columna 2
        row = sheet.getRow((short)13);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.calleBusqueda"));
        cell = row.createCell((short)2);
        if(!StringUtils.isEmpty(delegacionesBean.getCalle())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("2"),W83bClsConstantes.DOCE,Short.parseShort("6")));//NOPMD
	        cell.setCellValue(delegacionesBean.getCalle().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.localidadBusqueda"));
        cell = row.createCell((short)10);
        if(!StringUtils.isEmpty(delegacionesBean.getLocalidad())){
	        sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("10"),W83bClsConstantes.TRECE,Short.parseShort("12")));//NOPMD
	        cell.setCellValue(delegacionesBean.getDescLocalidad().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
		}else{
	       	cell.setCellValue("");
	    }
			
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.numModeloSalidaBusqueda"));
        cell = row.createCell((short)16);
        if(!StringUtils.isEmpty(delegacionesBean.getNumModeloSalida())){
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getNumModeloSalida()));
        	cell.setCellStyle(estiloCabeceraIzquierda(13,excel));
        }else{
        	cell.setCellValue("");
        }
        
      //fila 12, columna 2
        row = sheet.getRow((short)14);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.numeroBusqueda"));
        cell = row.createCell((short)2);
        if(!StringUtils.isEmpty(delegacionesBean.getNumero())){
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getNumero()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.telefono1Busqueda"));
        cell = row.createCell((short)10);
        if(!StringUtils.isEmpty(delegacionesBean.getTelefono1())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("10"),W83bClsConstantes.CATORCE,Short.parseShort("11")));//NOPMD
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getTelefono1()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell((short)13);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.registroEntradaBusqueda"));
        cell = row.createCell((short)16);
        if(delegacionesBean.getRegistroEntrada().equalsIgnoreCase("0")){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.regManual",idioma).toUpperCase());
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.regAutomatico",idioma).toUpperCase());
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
        
        //fila 13, columna 2
        row = sheet.getRow((short)15);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.pisoBusqueda"));        
        cell = row.createCell((short)2);
        if(!StringUtils.isEmpty(delegacionesBean.getPiso())){
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getPiso()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.QUINCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.telefono2Busqueda"));
        cell = row.createCell((short)10);
        if(!StringUtils.isEmpty(delegacionesBean.getTelefono2())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE,Short.parseShort("10"),W83bClsConstantes.QUINCE,Short.parseShort("11")));//NOPMD
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getTelefono2()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.QUINCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        
        //fila 14, columna 2
        row = sheet.getRow((short)16);
        cell = row.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.letraBusqueda"));        
        cell = row.createCell((short)2);
        if(StringUtils.isNotEmpty(delegacionesBean.getLetra())){
        	cell.setCellValue(delegacionesBean.getLetra().toUpperCase());
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISEIS,excel,wb));
        }else{
        	cell.setCellValue(delegacionesBean.getLetra());
        }
        cell = row.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.faxBusqueda"));
        cell = row.createCell((short)10);
        if(!StringUtils.isEmpty(delegacionesBean.getFax())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS,Short.parseShort("10"),W83bClsConstantes.DIECISEIS,Short.parseShort("11")));//NOPMD
        	cell.setCellValue(W83bUtilidades.numero(delegacionesBean.getFax()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DIECISEIS,excel,wb));
        }else{
        	cell.setCellValue("");
        }

        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamanyo columna en chars)/(1/20)
        row = sheet.getRow((short)19); // Creacin de la fila 19
        cell = row.getCell((short)0); // Creacin de la columna 2 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.codTerritorioBusqueda"));
        
        cell = row.getCell((short)1); // Creacin de la columna 3 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.direccionBusqueda"));
        
        cell = row.getCell((short)3); // Creacin de la columna 4 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.codPostalBusqueda"));
        
        cell = row.getCell((short)5); // Creacin de la columna 5 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.localidadBusqueda"));
        
        cell = row.getCell((short)6); // Creacin de la columna 6 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.telefono1Busqueda"));
        
        cell = row.getCell((short)8); // Creacin de la columna 7 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.telefono2Busqueda"));
        
        cell = row.getCell((short)10); // Creacin de la columna 8 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.faxBusqueda"));
        
        cell = row.getCell((short)12); // Creacin de la columna 9 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.registroEntradaBusqueda"));
        
        cell = row.getCell((short)14); // Creacin de la columna 11 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.numModeloBusqueda"));
        
        cell = row.getCell((short)16); // Creacin de la columna 13 para la fila 19
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.delegaciones.numModeloSalidaBusqueda"));
        

        for(int i=0;i<listaDelegaciones.size();i++){
        	row = sheet.createRow((short)20+i); // Creacin de la fila 17

        	//Cod territorio
        	cell = row.createCell((short)0);
        	if(StringUtils.isNotEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDescTerritorio())){
        		if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(((W83bDelegacionesBean)listaDelegaciones.get(i)).getCodTerritorio())){
        			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.servCentrales",idioma).toUpperCase());
        		}else{
        			cell.setCellValue(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDescTerritorio().toUpperCase());
        		}
        	}else{
        		cell.setCellValue(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDescTerritorio());
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));

        	//Cod direccin
        	cell = row.createCell((short)1);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("1"),W83bClsConstantes.VEINTE+i,Short.parseShort("2")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDescDireccionFormato())){
        		cell.setCellValue(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDescDireccionFormato());
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell((short)2); 
        	cell.setCellStyle(this.estiloFila(i,excel));

        	//Descripcin codPostal
        	cell = row.createCell((short)3);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("3"),W83bClsConstantes.VEINTE+i,Short.parseShort("4")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getCodPostal())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bDelegacionesBean)listaDelegaciones.get(i)).getCodPostal()));
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)4); 
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));

        	//Descripcin localidad
        	cell = row.createCell((short)5);
        	if(StringUtils.isNotEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDescLocalidad())){
        		cell.setCellValue(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDescLocalidad().toUpperCase());
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Descripcin telfono1
        	cell = row.createCell((short)6);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("6"),W83bClsConstantes.VEINTE+i,Short.parseShort("7")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getTelefono1())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bDelegacionesBean)listaDelegaciones.get(i)).getTelefono1()));
        	}
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)7); 
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	//Descripcin telfono2
        	cell = row.createCell((short)8);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("8"),W83bClsConstantes.VEINTE+i,Short.parseShort("9")));//NOPMD
        	if(!StringUtils.isEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getTelefono2())){
            	cell.setCellValue(W83bUtilidades.numero(((W83bDelegacionesBean)listaDelegaciones.get(i)).getTelefono2()));
            }else{
            	cell.setCellValue("");
            }
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)9); 
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	//Descripcin fax
        	cell = row.createCell((short)10);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("10"),W83bClsConstantes.VEINTE+i,Short.parseShort("11")));//NOPMD
        	if(!StringUtils.isEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getFax())){
            	cell.setCellValue(W83bUtilidades.numero(((W83bDelegacionesBean)listaDelegaciones.get(i)).getFax()));
            }else{
            	cell.setCellValue("");
            }
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)11); 
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	

        	
        	//Descripcin registro
        	cell = row.createCell((short)12);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("12"),W83bClsConstantes.VEINTE+i,Short.parseShort("13")));//NOPMD
        	 if(((W83bDelegacionesBean)listaDelegaciones.get(i)).getRegistroEntrada().equalsIgnoreCase("0")){
             	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.regAutomatico",idioma).toUpperCase());
             }else{
             	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.delegaciones.regManual",idioma).toUpperCase());
             }
        	 cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	 cell = row.createCell((short)13); 
         	 cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	 
        	//Descripcin secretario
         	cell = row.createCell((short)14);
         	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("14"),W83bClsConstantes.VEINTE+i,Short.parseShort("15")));//NOPMD
         	if(StringUtils.isNotEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getNumModelo())){
         		cell.setCellValue(W83bUtilidades.numero(((W83bDelegacionesBean)listaDelegaciones.get(i)).getNumModelo()));
         	}else{
         		cell.setCellValue("");
         	}

         	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
         	cell = row.createCell((short)15); 
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	 
         	//Descripcin secretario
        	cell = row.createCell((short)16);
        	sheet.addMergedRegion(new Region(W83bClsConstantes.VEINTE+i,Short.parseShort("16"),W83bClsConstantes.VEINTE+i,Short.parseShort("17")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bDelegacionesBean)listaDelegaciones.get(i)).getNumModeloSalida())){
         		cell.setCellValue(W83bUtilidades.numero(((W83bDelegacionesBean)listaDelegaciones.get(i)).getNumModeloSalida()));
         	}else{
         		cell.setCellValue("");
         	}

        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell((short)17); 
        	cell.setCellStyle(estiloFilaNumeroCentrado(i,excel));
        	
        	if((((W83bDelegacionesBean)listaDelegaciones.get(i)).getDireccion()).length()>=(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDireccion()).length()){
	        	if(47<(((W83bDelegacionesBean)listaDelegaciones.get(i)).getDireccion()).length()){
	        		row.setHeightInPoints((short)(22*((((W83bDelegacionesBean)listaDelegaciones.get(i)).getDireccion()).length()/47)+1));
	        	}
	        }
        }
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoDelegaciones.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		return null;
	}
	

	/**
	 * Estilo fila.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	
	/**
	 * Estilo cabecera izquierda.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloCabeceraIzquierda(int nFila, W83bUtilidadesExcel excel){
		return excel.styleCabeceraIzquierda;
	}
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}